import java.util.HashSet;
/**
 * Justification - a justification for a belief.
 * The justification may be operative (endorsed at that point) or not.
 * A justification consists of premises/sentences which in the eye of 
 * the agent support a conclusion in question.
 *
 * @author MB
 * @version MAY 2021
 */
public class Justification
{
    private boolean operative;
    private final HashSet<Sentence> premises;
    /**
     * Constructor for objects of class Justification.
     * A justification may consist of any number of premises.
     */
    public Justification(Sentence... args)
    {
        premises = new HashSet<Sentence>();
        for(int i = 0; i < args.length; i++){
            premises.add(args[i]);
        }
    }
    
    /**
     * Sets the justification operative.
     */
    public void endorse(){
         operative = true;   
    }
    
    /**
     * In case a justification has to be givenup, because its conclusion is surrendered, 
     * the least entrenched premise has to be found, to be surrendered in a contraction.
     */
    public Sentence giveLeastEntrenched(){
        Sentence out = new Sentence("No Content");
        int minimum = Integer.MAX_VALUE;
        for(Sentence s: premises){
            if(s.entrenchmentLevel() < minimum){
                 out = s;
                 minimum = s.entrenchmentLevel();
            }
        }
        return out;
    }
    
    public HashSet<Sentence> givePremises(){
         return premises;   
    }
    
    public boolean isOperative(){
        return operative;    
    }
    
    /**
     * Sets the justification inoperative.
     */
    public void surrender(){
         operative = false;   
    }
    
    
}
